#include <iostream>
using namespace std;

class IUSBDevice { // Interfejs
   public:
     virtual void readUSBData() = 0;
     virtual void writeUSBData() = 0;
     virtual ~IUSBDevice() {
        cout <<"Destruktor wirtualny interfejsu\n";
     }
 };
//---------------------------------------------------------
class TAsynchReadWrite : public IUSBDevice {
   public:
     void readUSBData() {
        cout << "TAsynchReadWrite::readUSBData()\n";
     }
     void writeUSBData() {
        cout << "TAsynchReadWrite::writeUSBData()\n";
     }
     TAsynchReadWrite() {
        cout << "Konstruktor TAsynchReadWrite\n";
     }
     ~TAsynchReadWrite() {
        cout << "Destruktor TAsynchReadWrite\n\n";
     }
 };
//---------------------------------------------------------
class TSynchReadWrite : public IUSBDevice {
   public:
     void readUSBData() {
        cout << "TSynchReadWrite::readUSBData()\n";
     }
     void writeUSBData() {
        cout << "TSynchReadWrite::writeUSBData()\n";
     }
     TSynchReadWrite() {
        cout << "Konstruktor TSynchReadWrite\n";
     }
     ~TSynchReadWrite() {
        cout << "Destruktor TSynchReadWrite\n\n";
     }
 };
//---------------------------------------------------------
class TUSBDevice : public IUSBDevice {
   public:
     // Konstruktor TUSBDevice wywouje
     // konstruktor TAsynchReadWrite
     TUSBDevice() : ptrIUSBDevice( new TAsynchReadWrite() ) {
       cout << "Konstruktor TUSBDevice\n";
     }
     // Destruktor klasy TUSBDevice
     ~TUSBDevice() { delete ptrIUSBDevice; }
     void readUSBData() { ptrIUSBDevice->readUSBData(); }
     void writeUSBData() { ptrIUSBDevice->writeUSBData(); }
     void delegationToTSynchReadWrite() {
       delete ptrIUSBDevice;
       ptrIUSBDevice = new TSynchReadWrite();
     }
     void delegationToTAsynchReadWrite() {
       delete ptrIUSBDevice;
       ptrIUSBDevice = new TAsynchReadWrite();
     }
   private:
     // Agregacja interfejsu IUSBDevice z klas TUSBDevice
     IUSBDevice* ptrIUSBDevice;
 };
//---------------------------------------------------------
int main() {
   // Tworzony jest obiekt anonimowy klasy TAsynchReadWrite,
   // a nastpnie nazwany obiekt usbDevice klasy TUSBDevice
   TUSBDevice usbDevice;
   // Wywoywane s metody klasy TAsynchReadWrite
   usbDevice.readUSBData();
   usbDevice.writeUSBData();
   // Wywoywany jest destruktor klasy TAsynchReadWrite
   // i tworzony obiekt anonimowy klasy TSynchReadWrite
   usbDevice.delegationToTSynchReadWrite();
   // Wywoywane s metody klasy TSynchReadWrite
   usbDevice.readUSBData();
   usbDevice.writeUSBData();
   //acuch delegacji moe by powtarzany wielokrotnie
   usbDevice.delegationToTAsynchReadWrite();
   usbDevice.readUSBData();
   usbDevice.writeUSBData();
   cin.get();
   return 0;
}
 
